#pragma rtGlobals=1		// Use modern global access method.

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												FONCTION GEOMETRIQUE
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  

function SelectEnergy(particle,energy, denergy,w)
	variable energy, denergy
	string particle
	wave w
	WAVE e_part = $("e_"+particle)
	w=(abs(e_part-energy)<denergy)
end


function OrientLight(particle,thet,dthet,phi,dphi,w)
	variable thet,dthet,dphi,phi
	string particle
	wave w
	
	WAVE thet_part = $("thet_"+particle)
	WAVE phi_part = $("phi_"+particle)
	w*=  (abs(thet_part-thet)<dthet)%&  (abs(phi_part-phi)<dphi)
end


function OrientLab(particle,thet,dthet,phi,dphi,w)
	variable thet,dthet,dphi,phi
	string particle
	wave w
	WAVE thet_part = $("dvthet_"+particle)
	WAVE phi_part = $("dvphi_"+particle)
	w*= (abs(thet_part-thet)<dthet)%&  (abs(abs(phi_part)-phi)<dphi)
end

function Aligne(particle1, particle2, dcone,w)
	string particle1, particle2
	variable dcone
	wave w
	
	WAVE thet12 = $("thet_"+particle1+particle2)

	w*= (abs(thet12-Pi)<dcone)
end

// new function 22/02/05

function Mol_Horiz(thet,dthet,dphi,w)
	variable thet,dthet,dphi
	wave w
	WAVE thet1=thet_i1
	WAVE thet2=thet_i2
	WAVE phi1=phi_i1
	WAVE phi2=phi_i2
	w*= ((abs(phi1)<dphi)%&(abs(thet1-thet)<dthet))%|((abs(phi2)<dphi)%&(abs(thet2-thet)<dthet))
	
end

// new function 16/05/05

function Mol_vert(dthet,dphi,w)
	variable dthet,dphi
	wave w
	WAVE thet1=thet_i1
	WAVE thet2=thet_i2
	WAVE phi1=phi_i1
	WAVE phi2=phi_i2
	w= ((abs(phi1+pi/2)<dphi)%&(abs(thet1-pi/2)<dthet))%|((abs(phi2-pi/2)<dphi)%&(abs(thet2-pi/2)<dthet))
	
end

// new function 19/05/05

function SelectKER(energy, denergy,w)
	variable energy, denergy
	wave w
	WAVE Ei1 = e_i1
	WAVE Ei2 = e_i2
	w=(abs(Ei1+Ei2-energy)<denergy)
end



//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												PONDERATION
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  
function ponder1D(w)
	wave w
	string Name
	variable x0, dx
	x0=leftx(w)
	dx=deltax(w)
	name=nameofwave(w)
	duplicate/O w, $(name+"_pond")
	execute(name+"_pond="+name+"/abs(sin(x))")
	//execute(name+"_pond="+name+"_pond/area("+name+"_pond,0,Inf)*area("+name+",0,Inf)")
end
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												InvertSum
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  
function InvertSum(w1,w2)
	wave w1,w2
	variable i,size=numpnts(w1)
	for (i=0;i<size;i+=1)
		w1[i]+=w2[size-i]
	endfor
end
//---------------------------------------------------------------------------------------------------------------------------
//												Symmetrize
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  
function Symmetrize(w1,w2)
	wave w1,w2
	variable i, mid, size=numpnts(w1)
	mid=ceil(size/2)
	w1=0
	for (i=0;i<mid;i+=1)
		w1[i]+=0.5*(w2[i]+w2[size-i])
	endfor
	for (i=mid;i<size;i+=1)
		w1[i]+=w1[size-i-1]
	endfor
end

//---------------------------------------------------------------------------------------------------------------------------
//												Mirror_V
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  
function Mirror_V(w1)
	wave w1
	variable i, quad, mid, size=numpnts(w1),a,b
	quad=ceil(size/4);mid=ceil(size/2)
	a=w1[0];b=w1[mid-1]
	w1[0]=b;w1[mid-1]=a
	for (i=1;i<quad+1;i+=1)
		a=w1[i];b=w1[mid-i-1]
		w1[i]=b;w1[mid-i-1]=a
		a=w1[mid+i-1];b=w1[size-i]
		w1[mid+i-1]=b;w1[size-i]=a	
	endfor
end

//---------------------------------------------------------------------------------------------------------------------------
//												Mirror_H
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  
function Mirror_H(w1)
	wave w1
	variable i, mid, size=numpnts(w1),a,b
	mid=ceil(size/2)
	for (i=0;i	<mid;i+=1)
		a=w1[i];b=w1[size-i-1]
		w1[i]=b;w1[size-i-1]=a
	endfor
end

